<?php
	
	/**
	 *  The Contact form gets generated by the avia_form class located in framework/php/class-form-generator.php
	 */
 

	$form_args = array(
		
		"heading" => "<h3>".__('Send us mail','avia_framework')."</h3>",
		"success" => "<h3>".__('Your message has been sent!','avia_framework')."</h3><p>".__('Thank you!','avia_framework')."</p>",
		"submit"  => __('Send','avia_framework'),
		"action"  => get_permalink(),
		"myemail" => avia_get_option('email'),
		"myblogname" => get_option('blogname'),
		"autoresponder" => avia_get_option('autoresponder'),
		"autoresponder_subject" => __('Thank you for your Message!','avia_framework'),
		"autoresponder_email" => avia_get_option('email')
	);
	
	
	
	
	//default elements
	$elements = array(
	
		'username'	=> 	array('type'=>'decoy',	'label'=>'', 'check'=>'must_empty'),										//decoy input field for bots, input field gets hidden, if bot enters value form wont be submitted
	
	);
	
	//user defined elements from backend
	$custom_elements = avia_get_option('contact-form-elements');
	
	if(is_array($custom_elements))
	{
		foreach($custom_elements as $new_element)
		{
			$elements[strtolower( $new_element['label'] ) ] = $new_element;
		}
	}
	
	if(avia_get_option('contact-form-captcha') === 'active')
	{
		$elements['age'] =	array('type'=>'captcha', 'check'=>'captcha', 'label'=> __('Please prove that you are human by solving the equation','avia_framework'));
	}
	
	//hook into the default form and modify the values
	$form_args = apply_filters('avia_contact_form_args', $form_args);
	$elements  = apply_filters('avia_contact_form_elements', $elements);
	
	
	
	$contact_form = new avia_form($form_args);
	$contact_form->create_elements($elements);
	$contact_form->display_form();
	

?>
